package Jarras;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class VentanaJarra2 extends JFrame{
	private ConjuntoDeJarras jarras;
	private JPanel miPanel;
	private JPanel pnlAUsar;
	private JLabel lblEstadoJarra;
	private JLabel lblAServir;
	private JLabel lblAAgregar;
	private JTextField txtAServir;
	private JTextField txtAAgregar;
	private JButton btnServir;
	private JButton btnLlenar;
	private JButton btnAAgregar;
	private JTextField txtAUsar;
	private JButton btnAUsar;
	private int aUsar;

	public VentanaJarra2(ConjuntoDeJarras lasJarras) {
		super("USAR JARRA");
		jarras = lasJarras;
		aUsar = -1;  // indica ninguna jarra seleccionada

		this.setBounds(100, 100, 500, 300);

		miPanel = new JPanel();
		miPanel.setBorder(new EmptyBorder(5,5,5,5));
		miPanel.setLayout(null);

		this.setContentPane(miPanel);
		
		// contenido de panel de la ventana
		txtAUsar = new JTextField();
		txtAUsar.setBounds(50, 36, 65, 20);
		miPanel.add(txtAUsar);

		btnAUsar = new JButton("USAR");
		btnAUsar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				usarJarra();
			}

		});
		btnAUsar.setBounds(125, 36, 90, 20);
		miPanel.add(btnAUsar);

		pnlAUsar = new JPanel();
		pnlAUsar.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
		pnlAUsar.setBounds(50, 67, 311, 161);
		pnlAUsar.setLayout(null);
		pnlAUsar.setVisible(false);
		miPanel.add(pnlAUsar);
		
		// contenido de panel AUsar

		lblEstadoJarra = new JLabel("Sin jarra seleccionada.");
		lblEstadoJarra.setBounds(10, 18, 200, 15);
		pnlAUsar.add(lblEstadoJarra);

		lblAServir = new JLabel("Cantidad a servir: ");
		lblAServir.setBounds(10, 49, 115, 15);
		pnlAUsar.add(lblAServir);

		txtAServir = new JTextField();
		txtAServir.setBounds(125, 44, 65, 20);
		pnlAUsar.add(txtAServir);

		btnServir = new JButton("SERVIR");
		btnServir.setBounds(200, 44, 90, 20);
		btnServir.addActionListener(new ActionListener() { 
			public void actionPerformed(ActionEvent e) {
				servirDeJarra();
				mostrarEstado();
			}
		});
		pnlAUsar.add(btnServir);
		
		btnLlenar = new JButton("LLENAR");
		btnLlenar.setBounds(200, 75, 91, 20);
		pnlAUsar.add(btnLlenar);

		btnLlenar.addActionListener(new ActionListener() { 
			public void actionPerformed(ActionEvent e) {
				jarras.getJarra(aUsar).llenar();
				mostrarEstado();
			}
		});	
		
		btnAAgregar = new JButton("AGREGAR");
		btnAAgregar.setBounds(200, 106, 91, 20);
		pnlAUsar.add(btnAAgregar);

		txtAAgregar = new JTextField();
		txtAAgregar.setBounds(125, 106, 65, 20);
		pnlAUsar.add(txtAAgregar);

		lblAAgregar= new JLabel("Cantidad a agregar: ");
		lblAAgregar.setBounds(10, 109, 116, 15);
		pnlAUsar.add(lblAAgregar);
		
		btnAAgregar.addActionListener(new ActionListener() { 
			public void actionPerformed(ActionEvent e) {
				agregarAJarra();
				mostrarEstado();
			}
		});

	}
	
	private void usarJarra() {
		aUsar = Integer.parseInt(txtAUsar.getText());
		mostrarEstado();
		pnlAUsar.setVisible(true);
	}
	
	private void agregarAJarra() {
		int auxCantidad = Integer.parseInt(txtAAgregar.getText());
		jarras.getJarra(aUsar).agregar(auxCantidad);
	}
	
	private void servirDeJarra() {
		int auxCantidad = Integer.parseInt(txtAServir.getText());
		jarras.getJarra(aUsar).servir(auxCantidad);
	}
	
	private void mostrarEstado() {
		lblEstadoJarra.setText(jarras.getJarra(aUsar).toString());
	}
}
