package Jarras;

public class JarraElectrica extends Jarra {
	private boolean enchufada;
	private boolean caliente;
	
	public JarraElectrica(int capacidad) {
		super(capacidad);
		this.enchufada = false;
		this.caliente = false;
	}
	
	public void enchufar() {
		this.enchufada = true;
	}
	
	public void calentar() {
		if (estaEnchufada() & !super.estaVacia()) {
			this.caliente = true;
		}
	}
	
	public void llenar() {
		super.llenar();
		this.caliente = false;
	}
	
	public void servir(int cantidad) {
		super.servir(cantidad);
		if (super.estaVacia()) {
			this.caliente = false;
		}
	}
	
	public String toString() {
		String mensEnchufada = (estaEnchufada() ? "" : "des")+"enchufada";
		String mensCaliente = estaCaliente() ? "caliente" : "fría";
		return super.toString()+" Estoy "+mensEnchufada+" y "+mensCaliente+".";
	}
	
	public boolean estaEnchufada() {
		return enchufada;
	}
	
	public boolean estaCaliente() {
		return caliente;
	}

}
