package Jarras;

public class Jarra {
	private int capacidad;  // maximo posible en cc
	private int contenido;  // contenido actual en cc
	
	public Jarra(int capacidad) {
		this.capacidad = capacidad;
		this.contenido = 0;
	}
	
	public void llenar() {
		this.contenido = this.capacidad;
	}
	
	public void agregar(int cantidad) {
		this.contenido = this.contenido + cantidad;
		if (this.contenido > this.capacidad) {
			this.contenido = this.capacidad;
		}
	}

	public void servir(int cantidad) {
		if (this.contenido >= cantidad) {
			this.contenido = this.contenido - cantidad;
		}else {
			this.contenido = 0;
		}
	}
	
	public int getContenido() {
		return this.contenido;
	}
	
	public int getCapacidad() {
		return this.capacidad;
	}
	
	public boolean estaVacia() {
		return (this.contenido == 0);
	}

	public String toString() {
		return "Tengo "+this.contenido+" cc de "+this.capacidad+" cc.";
	}
	

}
