package Jarras;

public class CafeteraElectrica extends JarraElectrica {
	private boolean cafe;
	
	public CafeteraElectrica(int capacidad) {
		super(capacidad);
		this.cafe = false;
	}
	
	public void cargarCafe() {
		this.cafe = true;
	}
	
	public void calentar() {
		if (this.cafe) {
			super.calentar();
		}
	}
	
	public void servir(int cantidad) {
		super.servir(cantidad);
		if(super.estaVacia()) {
			this.cafe = false;
		}
	}
	
	public void llenar() {
		super.llenar();
		this.cafe = false;
	}

}
